<?php

class OptimizeMikadoSideAreaOpener extends OptimizeMikadoWidget {
    public function __construct() {
        parent::__construct(
            'mkdf_side_area_opener', // Base ID
            esc_html__('Mikado Side Area Opener', 'mikado-core' ) // Name
        );

        $this->setParams();
    }

    protected function setParams() {

		$this->params = array(
			array(
				'name'			=> 'side_area_opener_icon_color',
				'type'			=> 'textfield',
				'title' => esc_html__( 'Icon Color', 'mikado-core' ),
				'description' => esc_html__( 'Define color for Side Area opener icon', 'mikado-core' )
			)
		);

    }


    public function widget($args, $instance) {
		
		$sidearea_icon_styles = array();

		if ( !empty($instance['side_area_opener_icon_color']) ) {
			$sidearea_icon_styles[] = 'color: ' . $instance['side_area_opener_icon_color'];
		}

	    print wp_kses_post($args['before_widget']);
		
		$icon_size = '';
		if ( optimize_mikado_options()->getOptionValue('side_area_predefined_icon_size') ) {
			$icon_size = optimize_mikado_options()->getOptionValue('side_area_predefined_icon_size');
		}

	    $default_sidearea_opener = optimize_mikado_options()->getOptionValue('side_area_enable_default_opener') === 'yes';

	    $default_sidearea_opener_class = $default_sidearea_opener ? 'mkdf-side-menu-button-opener-default' : '';

		?>
        <a class="mkdf-side-menu-button-opener <?php echo esc_attr( $icon_size.' '.$default_sidearea_opener_class ); ?>" <?php optimize_mikado_inline_style($sidearea_icon_styles) ?> href="javascript:void(0)">
            <?php echo optimize_mikado_get_side_menu_icon_html(); ?>
        </a>

	    <?php print wp_kses_post($args['after_widget']); ?>

    <?php }

}