<?php
namespace Optimize\Modules\Shortcodes\Process;

use Optimize\Modules\Shortcodes\Lib\ShortcodeInterface;

class ProcessItem implements ShortcodeInterface {
	private $base;

	public function __construct() {
		$this->base = 'mkdf_process_item';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	public function getBase() {
		return $this->base;
	}

	public function vcMap() {
		vc_map(array(
			'name' => esc_html__( 'Process Item', 'mikado-core' ),
			'base'                    => $this->getBase(),
			'as_child'                => array('only' => 'mkdf_process_holder'),
			'category' => esc_html__( 'by MIKADO', 'mikado-core' ),
			'icon'                    => 'icon-wpb-call-to-action extended-custom-icon',
			'show_settings_on_create' => true,
			'params'                  => array(
				array(
					'type'       => 'attach_image',
					'heading' => esc_html__( 'Image', 'mikado-core' ),
					'param_name' => 'image'
				),
				array(
					'type'        => 'textfield',
					'heading' => esc_html__( 'Title', 'mikado-core' ),
					'param_name'  => 'title',
					'save_always' => true,
					'admin_label' => true
				),
				array(
					'type'        => 'textarea',
					'heading' => esc_html__( 'Text', 'mikado-core' ),
					'param_name'  => 'text',
					'save_always' => true,
					'admin_label' => true
				),
				array(
					'type'        => 'dropdown',
					'heading' => esc_html__( 'Highlight Item?', 'mikado-core' ),
					'param_name'  => 'highlighted',
					'value'       => array(
						esc_html__('No', 'mikado-core' )  => 'no',
						esc_html__('Yes', 'mikado-core' ) => 'yes'
					),
					'save_always' => true,
					'admin_label' => true
				)
			)
		));
	}

	public function render($atts, $content = null) {
		$default_atts = array(
			'image'     => '',
			'title'     => '',
			'text'      => '',
			'highlighted' => ''
		);

		$params = shortcode_atts($default_atts, $atts);

		$params['item_classes'] = array(
			'mkdf-process-item-holder'
		);

		if($params['highlighted'] === 'yes') {
			$params['item_classes'][] = 'mkdf-pi-highlighted';
		}

		return mkd_core_get_core_shortcode_template_part('templates/process-item-template', 'process', '', $params);
	}

}