<?php
namespace Optimize\Modules\Shortcodes\Process;

use Optimize\Modules\Shortcodes\Lib\ShortcodeInterface;

class ProcessHolder implements ShortcodeInterface {
	private $base;

	public function __construct() {
		$this->base = 'mkdf_process_holder';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	public function getBase() {
		return $this->base;
	}

	public function vcMap() {
		vc_map(array(
			'name' => esc_html__( 'Process', 'mikado-core' ),
			'base'                    => $this->getBase(),
			'as_parent'               => array('only' => 'mkdf_process_item'),
			'content_element'         => true,
			'show_settings_on_create' => true,
			'category' => esc_html__( 'by MIKADO', 'mikado-core' ),
			'icon'                    => 'icon-wpb-call-to-action extended-custom-icon',
			'js_view'                 => 'VcColumnView',
			'params'                  => array(
				array(
					'type'        => 'dropdown',
					'param_name'  => 'number_of_items',
					'heading' => esc_html__( 'Number of Process Items', 'mikado-core' ),
					'value'       => array(
						esc_html__('Three', 'mikado-core' ) => 'three',
						esc_html__('Four', 'mikado-core' )  => 'four'
					),
					'save_always' => true,
					'admin_label' => true,
					'description' => ''
				)
			)
		));
	}

	public function render($atts, $content = null) {
		$default_atts = array(
			'number_of_items' => ''
		);

		$params            = shortcode_atts($default_atts, $atts);
		$params['content'] = $content;

		$params['holder_classes'] = array(
			'mkdf-process-holder',
			'mkdf-process-holder-items-'.$params['number_of_items']
		);

		return mkd_core_get_core_shortcode_template_part('templates/process-holder-template', 'process', '', $params);
	}
}